<?php

namespace Database\Seeders;

use App\Models\Currency;
use Illuminate\Database\Seeder;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class CurrencySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run()
    {
        $currencies = array(
            array('name' => 'Afghanistan Afghani', 'country_name' => 'Afghanistan', 'code' => 'AFN', 'rate' => '67.27', 'symbol' => '؋', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Albania Lek', 'country_name' => 'Albania', 'code' => 'ALL', 'rate' => '91.47', 'symbol' => 'L', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Algerian Dinar', 'country_name' => 'Algeria', 'code' => 'DZD', 'rate' => '133.08', 'symbol' => 'دج', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'US Dollar', 'country_name' => 'United States of America', 'code' => 'USD', 'rate' => '1.00', 'symbol' => '$', 'position' => 'left', 'status' => '1', 'is_default' => '1', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Angolan Kwanza', 'country_name' => 'Angola', 'code' => 'AOA', 'rate' => '910.98', 'symbol' => 'Kz', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Argentine Peso', 'country_name' => 'Argentina', 'code' => 'ARS', 'rate' => '1007.68', 'symbol' => '$', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Armenian Dram', 'country_name' => 'Armenia', 'code' => 'AMD', 'rate' => '389.25', 'symbol' => '֏', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Aruban Guilder', 'country_name' => 'Aruba', 'code' => 'AWG', 'rate' => '1.79', 'symbol' => 'ƒ', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Australian Dollar', 'country_name' => 'Australia', 'code' => 'AUD', 'rate' => '1.54', 'symbol' => '$', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Euro', 'country_name' => 'Austria', 'code' => 'EUR', 'rate' => '0.95', 'symbol' => '€', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Azerbaijan Manat', 'country_name' => 'Azerbaijan', 'code' => 'AZN', 'rate' => '1.70', 'symbol' => '₼', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Bahamian Dollar', 'country_name' => 'Bahamas', 'code' => 'BSD', 'rate' => '1.00', 'symbol' => '$', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Bahraini Dinar', 'country_name' => 'Bahrain', 'code' => 'BHD', 'rate' => '0.38', 'symbol' => '.د.ب', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Bangladesh Taka', 'country_name' => 'Bangladesh', 'code' => 'BDT', 'rate' => '119.00', 'symbol' => '৳', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Barbados Dollar', 'country_name' => 'Barbados', 'code' => 'BBD', 'rate' => '2.00', 'symbol' => '$', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Belarusian Ruble', 'country_name' => 'Belarus', 'code' => 'BYN', 'rate' => '3.43', 'symbol' => 'Br', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Belize Dollar', 'country_name' => 'Belize', 'code' => 'BZD', 'rate' => '2.00', 'symbol' => '$', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Bermuda Dollar', 'country_name' => 'Bermuda', 'code' => 'BMD', 'rate' => '1.00', 'symbol' => '$', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Bhutan Ngultrum', 'country_name' => 'Bhutan', 'code' => 'BTN', 'rate' => '84.45', 'symbol' => 'Nu.', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Bolivia Boliviano', 'country_name' => 'Bolivia', 'code' => 'BOB', 'rate' => '6.86', 'symbol' => 'Bs.', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Bosnia and Herzegovina Convertible Mark', 'country_name' => 'Bosnia and Herzegovina', 'code' => 'BAM', 'rate' => '1.85', 'symbol' => 'KM', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Botswana Pula', 'country_name' => 'Botswana', 'code' => 'BWP', 'rate' => '13.55', 'symbol' => 'P', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Brazilian Real', 'country_name' => 'Brazil', 'code' => 'BRL', 'rate' => '5.82', 'symbol' => 'R$', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Brunei Dollar', 'country_name' => 'Brunei', 'code' => 'BND', 'rate' => '1.34', 'symbol' => '$', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Bulgarian Lev', 'country_name' => 'Bulgaria', 'code' => 'BGN', 'rate' => '1.85', 'symbol' => 'лв', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Burundi Franc', 'country_name' => 'Burundi', 'code' => 'BIF', 'rate' => '2885.73', 'symbol' => 'FBu', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Cambodian Riel', 'country_name' => 'Cambodia', 'code' => 'KHR', 'rate' => '4017.00', 'symbol' => '៛', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Canadian Dollar', 'country_name' => 'Canada', 'code' => 'CAD', 'rate' => '1.40', 'symbol' => '$', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Cape Verde Escudo', 'country_name' => 'Cape Verde', 'code' => 'CVE', 'rate' => '104.50', 'symbol' => '$', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Cayman Is. Dollar', 'country_name' => 'Cayman Islands', 'code' => 'KYD', 'rate' => '0.82', 'symbol' => '$', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Chilean Peso', 'country_name' => 'Chile', 'code' => 'CLP', 'rate' => '973.00', 'symbol' => '$', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Chinese Renminbi', 'country_name' => 'China', 'code' => 'CNY', 'rate' => '7.25', 'symbol' => '¥', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Colombian Peso', 'country_name' => 'Colombia', 'code' => 'COP', 'rate' => '4413.00', 'symbol' => '$', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Comoros Franc', 'country_name' => 'Comoros', 'code' => 'KMF', 'rate' => '466.23', 'symbol' => 'CF', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Congo Franc, Dem. Rep.of', 'country_name' => 'Congo, Dem. Rep.', 'code' => 'CDF', 'rate' => '2843.07', 'symbol' => 'FC', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Costa Rica Colon', 'country_name' => 'Costa Rica', 'code' => 'CRC', 'rate' => '509.02', 'symbol' => '₡', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Cuban Peso', 'country_name' => 'Cuba', 'code' => 'CUP', 'rate' => '24.00', 'symbol' => '₱', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Czech Koruna', 'country_name' => 'Czech Republic', 'code' => 'CZK', 'rate' => '23.97', 'symbol' => 'Kč', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Danish Krone', 'country_name' => 'Denmark', 'code' => 'DKK', 'rate' => '7.07', 'symbol' => 'kr', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Djibouti Francs', 'country_name' => 'Djibouti', 'code' => 'DJF', 'rate' => '177.00', 'symbol' => 'Fdj', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'E.C. Dollar', 'country_name' => 'Anguilla', 'code' => 'XCD', 'rate' => '2.70', 'symbol' => '$', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Dominican Peso', 'country_name' => 'Dominican Republic', 'code' => 'DOP', 'rate' => '60.17', 'symbol' => 'RD$', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Egyptian Pound', 'country_name' => 'Egypt', 'code' => 'EGP', 'rate' => '49.61', 'symbol' => '£', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Eritrea Nakfa', 'country_name' => 'Eritrea', 'code' => 'ERN', 'rate' => '15.00', 'symbol' => 'Nfk', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Lilangeni', 'country_name' => 'Eswatini, Kingdom of', 'code' => 'SZL', 'rate' => '18.16', 'symbol' => 'E', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Ethiopian Birr', 'country_name' => 'Ethiopia', 'code' => 'ETB', 'rate' => '121.81', 'symbol' => 'Br', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Fiji Dollar', 'country_name' => 'Fiji', 'code' => 'FJD', 'rate' => '2.25', 'symbol' => '$', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Gambian Dalasi', 'country_name' => 'Gambia', 'code' => 'GMD', 'rate' => '70.41', 'symbol' => 'D', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Georgian Lari', 'country_name' => 'Georgia', 'code' => 'GEL', 'rate' => '2.74', 'symbol' => '₾', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Ghana Cedi', 'country_name' => 'Ghana', 'code' => 'GHS', 'rate' => '15.50', 'symbol' => '₵', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Gibraltar Pound', 'country_name' => 'Gibraltar', 'code' => 'GIP', 'rate' => '0.79', 'symbol' => '£', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Guatemala Quetzal(es)', 'country_name' => 'Guatemala', 'code' => 'GTQ', 'rate' => '7.71', 'symbol' => 'Q', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Guinean Franc', 'country_name' => 'Guinea', 'code' => 'GNF', 'rate' => '8552.17', 'symbol' => 'FG', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Guyana Dollar', 'country_name' => 'Guyana', 'code' => 'GYD', 'rate' => '207.90', 'symbol' => '$', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Haiti Gourde', 'country_name' => 'Haiti', 'code' => 'HTG', 'rate' => '130.93', 'symbol' => 'G', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Honduras Lempira', 'country_name' => 'Honduras', 'code' => 'HNL', 'rate' => '24.96', 'symbol' => 'L', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'HongKong Dollar', 'country_name' => 'Hong Kong', 'code' => 'HKD', 'rate' => '7.78', 'symbol' => 'HK$', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Hungary Forint', 'country_name' => 'Hungary', 'code' => 'HUF', 'rate' => '391.50', 'symbol' => 'Ft', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Iceland Krona', 'country_name' => 'Iceland', 'code' => 'ISK', 'rate' => '137.04', 'symbol' => 'kr', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Indian Rupee', 'country_name' => 'India', 'code' => 'INR', 'rate' => '84.45', 'symbol' => '₹', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Indonesia Rupiah', 'country_name' => 'Indonesia', 'code' => 'IDR', 'rate' => '15930.00', 'symbol' => 'Rp', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Iranian Rial', 'country_name' => 'Iran', 'code' => 'IRR', 'rate' => '512897.00', 'symbol' => '﷼', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Iraqi Dinar', 'country_name' => 'Iraq', 'code' => 'IQD', 'rate' => '1310.00', 'symbol' => 'ع.د', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Israel Shekel', 'country_name' => 'Israel', 'code' => 'ILS', 'rate' => '3.65', 'symbol' => '₪', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Jamaican Dollar', 'country_name' => 'Jamaica', 'code' => 'JMD', 'rate' => '157.35', 'symbol' => 'J$', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Japanese Yen', 'country_name' => 'Japan', 'code' => 'JPY', 'rate' => '151.42', 'symbol' => '¥', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Jordanian Dinar', 'country_name' => 'Jordan', 'code' => 'JOD', 'rate' => '0.71', 'symbol' => 'د.ا', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Kazakhstan Tenge', 'country_name' => 'Kazakhstan', 'code' => 'KZT', 'rate' => '502.23', 'symbol' => '₸', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Kenyan Shilling', 'country_name' => 'Kenya', 'code' => 'KES', 'rate' => '129.00', 'symbol' => 'KSh', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Korean Won, North Korea', 'country_name' => 'Korea, D.P.R. of', 'code' => 'KPW', 'rate' => '110.00', 'symbol' => '₩', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Korean Won, South Korea', 'country_name' => 'Korea, Republic of', 'code' => 'KRW', 'rate' => '1392.51', 'symbol' => '₩', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Kuwaiti Dinar', 'country_name' => 'Kuwait', 'code' => 'KWD', 'rate' => '0.31', 'symbol' => 'د.ك', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Kyrgyzstan Som', 'country_name' => 'Kyrgyzstan', 'code' => 'KGS', 'rate' => '86.25', 'symbol' => 'с', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Laos Kip', 'country_name' => 'Lao, People\'s Dem. Rep.', 'code' => 'LAK', 'rate' => '22020.00', 'symbol' => '₭', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Lebanese Pound', 'country_name' => 'Lebanon', 'code' => 'LBP', 'rate' => '89500.00', 'symbol' => 'ل.ل', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Lesotho Loti', 'country_name' => 'Lesotho', 'code' => 'LSL', 'rate' => '18.16', 'symbol' => 'M', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Liberian Dollar', 'country_name' => 'Liberia', 'code' => 'LRD', 'rate' => '179.39', 'symbol' => '$', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Libyan Dinar', 'country_name' => 'Libyan Arab Jamahiriya', 'code' => 'LYD', 'rate' => '4.89', 'symbol' => 'د.ل', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Macao Pataca', 'country_name' => 'Macao', 'code' => 'MOP', 'rate' => '8.02', 'symbol' => 'P', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Malagasy Ariary', 'country_name' => 'Madagascar', 'code' => 'MGA', 'rate' => '4667.74', 'symbol' => 'Ar', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Malawi Kwacha', 'country_name' => 'Malawi', 'code' => 'MWK', 'rate' => '1751.00', 'symbol' => 'MK', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Malaysia Ringgit', 'country_name' => 'Malaysia', 'code' => 'MYR', 'rate' => '4.44', 'symbol' => 'RM', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Maldives Rufiyaa', 'country_name' => 'Maldives', 'code' => 'MVR', 'rate' => '15.00', 'symbol' => 'Rf', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Mauritania Ouguiya', 'country_name' => 'Mauritania', 'code' => 'MRU', 'rate' => '39.77', 'symbol' => 'UM', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Mauritius Rupee', 'country_name' => 'Mauritius', 'code' => 'MUR', 'rate' => '46.64', 'symbol' => '₨', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Mexican Peso', 'country_name' => 'Mexico', 'code' => 'MXN', 'rate' => '20.68', 'symbol' => '$', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Moldovan Leu', 'country_name' => 'Moldova, Republic of', 'code' => 'MDL', 'rate' => '18.23', 'symbol' => 'L', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Mongolia Tugrik', 'country_name' => 'Mongolia', 'code' => 'MNT', 'rate' => '3406.00', 'symbol' => '₮', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Morocco Dirham', 'country_name' => 'Morocco', 'code' => 'MAD', 'rate' => '10.00', 'symbol' => 'د.م.', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Mozambique Metical', 'country_name' => 'Mozambique', 'code' => 'MZN', 'rate' => '63.25', 'symbol' => 'MT', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Myanmar Kyat', 'country_name' => 'Myanmar', 'code' => 'MMK', 'rate' => '4100.00', 'symbol' => 'K', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Namibia Dollar', 'country_name' => 'Namibia', 'code' => 'NAD', 'rate' => '18.16', 'symbol' => 'N$', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Nepalese Rupee', 'country_name' => 'Nepal', 'code' => 'NPR', 'rate' => '135.11', 'symbol' => '₨', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Netherlands Antilles Guilder', 'country_name' => 'Netherlands Antilles', 'code' => 'ANG', 'rate' => '1.79', 'symbol' => 'ƒ', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'CFP Franc', 'country_name' => 'New Caledonia', 'code' => 'XPF', 'rate' => '113.09', 'symbol' => '₣', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'New Zealand Dollar', 'country_name' => 'New Zealand', 'code' => 'NZD', 'rate' => '1.69', 'symbol' => '$', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Nicaragua Cordoba Oro', 'country_name' => 'Nicaragua', 'code' => 'NIO', 'rate' => '36.55', 'symbol' => 'C$', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Nigeria Naira', 'country_name' => 'Nigeria', 'code' => 'NGN', 'rate' => '1680.29', 'symbol' => '₦', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Denar', 'country_name' => 'North Macedonia, Rep. of', 'code' => 'MKD', 'rate' => '58.11', 'symbol' => 'ден', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Norwegian Krone', 'country_name' => 'Norway', 'code' => 'NOK', 'rate' => '11.07', 'symbol' => 'kr', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Oman Rial', 'country_name' => 'Oman', 'code' => 'OMR', 'rate' => '0.38', 'symbol' => 'ر.ع.', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Pakistani Rupee', 'country_name' => 'Pakistan', 'code' => 'PKR', 'rate' => '277.77', 'symbol' => '₨', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Panama Balboa', 'country_name' => 'Panama', 'code' => 'PAB', 'rate' => '1.00', 'symbol' => 'B/.', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Kina', 'country_name' => 'Papua New Guinea', 'code' => 'PGK', 'rate' => '3.95', 'symbol' => 'K', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Paraguay Guarani', 'country_name' => 'Paraguay', 'code' => 'PYG', 'rate' => '7804.00', 'symbol' => '₲', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Sol', 'country_name' => 'Peru', 'code' => 'PEN', 'rate' => '3.76', 'symbol' => 'S/', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Philippine Peso', 'country_name' => 'Philippines', 'code' => 'PHP', 'rate' => '58.70', 'symbol' => '₱', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Poland Zloty', 'country_name' => 'Poland', 'code' => 'PLN', 'rate' => '4.08', 'symbol' => 'zł', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Qatari Rial', 'country_name' => 'Qatar', 'code' => 'QAR', 'rate' => '3.65', 'symbol' => 'ر.ق.', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Romanian Leu', 'country_name' => 'Romania', 'code' => 'RON', 'rate' => '4.71', 'symbol' => 'lei', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Russian Rouble', 'country_name' => 'Russian Federation', 'code' => 'RUB', 'rate' => '111.60', 'symbol' => '₽', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Rwanda Franc', 'country_name' => 'Rwanda', 'code' => 'RWF', 'rate' => '1360.48', 'symbol' => 'FRw', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'St. Helena Pound', 'country_name' => 'Saint Helena', 'code' => 'SHP', 'rate' => '0.79', 'symbol' => '£', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Samoa Tala', 'country_name' => 'Samoa', 'code' => 'WST', 'rate' => '2.75', 'symbol' => 'T', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Sao Tome Principe Dobra', 'country_name' => 'Sao Tome and Principe', 'code' => 'STN', 'rate' => '23.28', 'symbol' => 'Db', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Saudi Riyal', 'country_name' => 'Saudi Arabia', 'code' => 'SAR', 'rate' => '3.76', 'symbol' => 'ر.س.', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'CFA Franc', 'country_name' => 'Senegal', 'code' => 'XOF', 'rate' => '621.64', 'symbol' => 'Fr', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Serbian Dinar', 'country_name' => 'Serbia', 'code' => 'RSD', 'rate' => '110.80', 'symbol' => 'дин.', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Seychelles Rupee', 'country_name' => 'Seychelles', 'code' => 'SCR', 'rate' => '13.65', 'symbol' => '₨', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Sierra Leone Leone', 'country_name' => 'Sierra Leone', 'code' => 'SLE', 'rate' => '23.39', 'symbol' => 'Le', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Singapore Dollar', 'country_name' => 'Singapore', 'code' => 'SGD', 'rate' => '1.34', 'symbol' => '$', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Solomon Is. Dollar', 'country_name' => 'Solomon Islands', 'code' => 'SBD', 'rate' => '8.29', 'symbol' => '$', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Somali Shilling', 'country_name' => 'Somalia', 'code' => 'SOS', 'rate' => '24300.00', 'symbol' => 'S', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'South Africa Rand', 'country_name' => 'South Africa', 'code' => 'ZAR', 'rate' => '18.16', 'symbol' => 'R', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'South Sudanese Pound', 'country_name' => 'South Sudan', 'code' => 'SSP', 'rate' => '3613.14', 'symbol' => 'SSP', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Sri Lanka Rupee', 'country_name' => 'Sri Lanka', 'code' => 'LKR', 'rate' => '290.57', 'symbol' => 'Rs', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Sudanese Pound', 'country_name' => 'Sudan', 'code' => 'SDG', 'rate' => '1987.00', 'symbol' => 'ج.س.', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Surinamese Dollar', 'country_name' => 'Suriname', 'code' => 'SRD', 'rate' => '35.52', 'symbol' => '$', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Swedish Krona', 'country_name' => 'Sweden', 'code' => 'SEK', 'rate' => '10.92', 'symbol' => 'kr', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Swiss Franc', 'country_name' => 'Switzerland', 'code' => 'CHF', 'rate' => '0.88', 'symbol' => 'CHF', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Syrian Pound', 'country_name' => 'Syrian Arab Republic', 'code' => 'SYP', 'rate' => '13600.00', 'symbol' => '£S', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Tajikistan Somoni', 'country_name' => 'Tajikistan', 'code' => 'TJS', 'rate' => '10.67', 'symbol' => 'SM', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Tanzania Shilling', 'country_name' => 'Tanzania, United Rep. of', 'code' => 'TZS', 'rate' => '2640.00', 'symbol' => 'TSh', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Thai Baht', 'country_name' => 'Thailand', 'code' => 'THB', 'rate' => '34.43', 'symbol' => '฿', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Tonga Pa\'anga', 'country_name' => 'Tonga', 'code' => 'TOP', 'rate' => '2.35', 'symbol' => 'T$', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Trinidad and Tobago Dollar', 'country_name' => 'Trinidad and Tobago', 'code' => 'TTD', 'rate' => '6.75', 'symbol' => 'TT$', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Tunisian Dinar', 'country_name' => 'Tunisia', 'code' => 'TND', 'rate' => '3.15', 'symbol' => 'د.ت', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Turkish Lira', 'country_name' => 'Turkey', 'code' => 'TRY', 'rate' => '34.66', 'symbol' => '₺', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Turkmenistan Manat', 'country_name' => 'Turkmenistan', 'code' => 'TMT', 'rate' => '3.50', 'symbol' => 'm', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Uganda Shilling', 'country_name' => 'Uganda', 'code' => 'UGX', 'rate' => '3682.00', 'symbol' => 'Sh', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Ukraine Hryvnia', 'country_name' => 'Ukraine', 'code' => 'UAH', 'rate' => '41.50', 'symbol' => '₴', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'United Arab Emirates Dirham', 'country_name' => 'United Arab Emirates', 'code' => 'AED', 'rate' => '3.67', 'symbol' => 'د.إ', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'U.K. Pound', 'country_name' => 'United Kingdom', 'code' => 'GBP', 'rate' => '0.79', 'symbol' => '£', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Uruguay Peso', 'country_name' => 'Uruguay', 'code' => 'UYU', 'rate' => '42.87', 'symbol' => '$', 'position' => 'left', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Uzbekistan Sum', 'country_name' => 'Uzbekistan', 'code' => 'UZS', 'rate' => '12830.00', 'symbol' => 'сўм', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Vanuatu Vatu', 'country_name' => 'Vanuatu', 'code' => 'VUV', 'rate' => '117.74', 'symbol' => 'Vt', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Bolivar Digital', 'country_name' => 'Venezuela', 'code' => 'VES', 'rate' => '46.33', 'symbol' => 'Bs.S', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Viet Nam Dong', 'country_name' => 'Viet Nam', 'code' => 'VND', 'rate' => '25384.00', 'symbol' => '₫', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Yemeni Rial', 'country_name' => 'Yemen, Republic of', 'code' => 'YER', 'rate' => '528.74', 'symbol' => '﷼', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Zambia Kwacha', 'country_name' => 'Zambia', 'code' => 'ZMW', 'rate' => '27.32', 'symbol' => 'ZK', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL),
            array('name' => 'Zimbabwe Gold', 'country_name' => 'Zimbabwe', 'code' => 'ZWG', 'rate' => '25.33', 'symbol' => 'ZWL', 'position' => 'right', 'status' => '1', 'is_default' => '0', 'created_at' => NULL, 'updated_at' => NULL)
        );

        Currency::insert($currencies);
    }
}
